import '../license';
import '@mescius/wijmo.cultures/wijmo.culture.ja';

import { Component, OnInit, ViewChild } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';
import { WjCoreModule } from '@mescius/wijmo.angular2.core';
import { WjInputModule } from '@mescius/wijmo.angular2.input';

import { DataService, PersonTaskData } from './data.service';
import { Person } from './persons-list/persons-list.component';
import { UserInfo, UserInfoComponent } from './user-info/user-info.component';
import { GanttChartComponent } from './gantt-chart/gantt-chart.component';
import { UserEditComponent } from './user-info/edit/user-edit.component';
import { MonthlyAchievementChartComponent } from './monthly-achievement-chart/monthly-achievement-chart.component';
import { TaskCompletionInfoComponent } from './task-completion-info/task-completion-info.component';
import { PersonsListComponent } from './persons-list/persons-list.component';

import { Popup } from '@mescius/wijmo.input';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css'],
  standalone: true,
  imports: [
    CommonModule,
    FormsModule,
    WjCoreModule,
    WjInputModule,
    MonthlyAchievementChartComponent,
    TaskCompletionInfoComponent,
    UserInfoComponent,
    PersonsListComponent,
    UserEditComponent,
    GanttChartComponent
  ]
})
export class AppComponent implements OnInit {
  title = 'Wijmo LiveMap';
  selectedCountryName: string;
  selectedPerson: Person | null = null;
  personTaskData: PersonTaskData[];
  showGantt = false;

  @ViewChild(UserEditComponent, { static: true })  userEditComp!: UserEditComponent;
  @ViewChild(UserInfoComponent) userInfoComp!: UserInfoComponent;
  @ViewChild(GanttChartComponent) ganttChartComp!: GanttChartComponent;
  @ViewChild('popup', { static: true }) popup!: Popup;

  constructor(private dataService: DataService) {
  }

  ngOnInit() {
    // 初期状態で最初の人物を選択
    this.selectedPerson = {
      id: 1,
      name: '仙台 太郎',
      department: '営業部'
    };
  }

  countryName(e: any) {
    this.selectedCountryName = e;
  }

  onPersonSelected(person: Person) {
    this.selectedPerson = person;

    // DataServiceから直接タスクデータを取得
    this.personTaskData = this.dataService.getPersonTaskData(
      this.selectedPerson.name,
      this.selectedPerson.department);
  }

  onPersonTaskDataChanged(updatePerson: Person) {
    // DataServiceから最新データを取得
    const updatedTaskData = this.dataService.getPersonTaskData(updatePerson.name, updatePerson.department);
    this.personTaskData = [...updatedTaskData]; // ← 参照を変えることで ngOnChanges が反応
  }

  toggleGanttChart() {
    this.showGantt = !this.showGantt;

    if (this.showGantt) {
      // FlexGridの幅を取得
      const gridWidth = this.userInfoComp.getFlexGridWidth();

      // FlexChartに幅を設定
      setTimeout(() => {
        this.ganttChartComp.setChartWidth(gridWidth);
      }, 0);
    }
  }

  openDialog() {
    this.popup.show(true);
  }

  closeDialog(updatedUser: UserInfo) {
    if (updatedUser !== null) {

      // 新しいオブジェクトを作成
      const { person, ...rest } = updatedUser;
      const newUser: PersonTaskData = {
        ...rest,
        user: person.name,
        percent: 0,
        parent: ''
      };
      
      // DataServiceに直接タスクを追加
      this.dataService.addPersonTaskData(person.name, newUser);
      
      // 親コンポーネントの personTaskData を更新（参照を変える）
      const updatedTaskData = this.dataService.getPersonTaskData(person.name, person.department);
      this.personTaskData = [...updatedTaskData]; // 参照を変えることで ngOnChanges が反応
    }
    this.popup.hide();
  }

  onPopupHidden(event: any) {
    this.userEditComp.clearErrorText();
  }
}

