import { Component, OnInit, Output, EventEmitter } from '@angular/core';
import { CommonModule } from '@angular/common';

export interface Person {
  id: number;
  name: string;
  department: string;
}

@Component({
  selector: 'app-persons-list',
  templateUrl: './persons-list.component.html',
  styleUrl: './persons-list.component.css',
  standalone: true,
  imports: [CommonModule]
})
export class PersonsListComponent implements OnInit {
  @Output() personSelected = new EventEmitter<Person>();
  
  selectedPersonId: number | null = 1; // 初期状態で最初の人物を選択
  
  persons: Person[] = [
    { id: 1, name: '仙台 太郎', department: '営業部' },
    { id: 2, name: '石巻 花子', department: '経理部' },
    { id: 3, name: '大崎 健一', department: '開発部' },
    { id: 4, name: '登米 美咲', department: '人事部' },
    { id: 5, name: '栗原 直樹', department: 'マーケティング部' },
    { id: 6, name: '気仙沼 愛美', department: '総務部' },
    { id: 7, name: '白石 雄介', department: '営業部' },
    { id: 8, name: '名取 智子', department: '品質管理部' },
    { id: 9, name: '角田 拓海', department: '開発部' },
    { id: 10, name: '多賀城 由美', department: '経理部' },
    { id: 11, name: '岩沼 慎也', department: 'IT部' },
    { id: 12, name: '富谷 麻衣', department: '人事部' },
    { id: 13, name: '塩竃 陽介', department: '営業部' },
    { id: 14, name: '東松島 静香', department: 'デザイン部' },
    { id: 15, name: '亘理 勇人', department: '製造部' },
    { id: 16, name: '山元 恵子', department: '総務部' },
    { id: 17, name: '松島 正明', department: '開発部' },
    { id: 18, name: '七ヶ浜 奈々', department: 'マーケティング部' },
    { id: 19, name: '利府 翔太', department: 'IT部' },
    { id: 20, name: '大和 美穂', department: '品質管理部' },
    { id: 21, name: '大郷 隆志', department: '営業部' },
    { id: 22, name: '大衡 千佳', department: '経理部' },
    { id: 23, name: '色麻 孝明', department: '開発部' },
    { id: 24, name: '加美 真理', department: 'デザイン部' },
    { id: 25, name: '涌谷 和也', department: '製造部' },
    { id: 26, name: '美里 綾香', department: '人事部' },
    { id: 27, name: '女川 康平', department: 'IT部' },
    { id: 28, name: '南三陸 清美', department: '総務部' },
    { id: 29, name: '川崎 裕一', department: 'マーケティング部' },
    { id: 30, name: '蔵王 絵里', department: '品質管理部' }
  ];

  constructor() { }

  ngOnInit(): void {
    // 初期状態で最初の人物が選択されていることを親コンポーネントに通知
    const firstPerson = this.persons[0];
    this.personSelected.emit(firstPerson);
  }

  selectPerson(person: Person): void {
    this.selectedPersonId = person.id;
    this.personSelected.emit(person);
  }
}
