import { PersonTaskData } from 'src/app/data.service';
import { Person } from '../persons-list/persons-list.component';

const sessionStorageKey = 'person_';

export const setSessionStoragePersonTaskData = (person: Person, personTaskData: PersonTaskData[]) => {
  sessionStorage.setItem(sessionStorageKey + person.id, JSON.stringify(personTaskData));
};


export const addSessionStoragePersonTaskData = (person: Person, newTask: PersonTaskData) => {
  const key = sessionStorageKey + person.id;
  const existingData = sessionStorage.getItem(key);

  let taskArray = [];

  if (existingData) {
    taskArray = JSON.parse(existingData);
  }

  // 追加
  taskArray.push(newTask);

  // 保存（文字列化）
  sessionStorage.setItem(key, JSON.stringify(taskArray));
};

export const getSessionStoragePersonTaskData = (person: Person) => {
  const personTaskData = sessionStorage.getItem(sessionStorageKey + person.id);
  if (!personTaskData) {
    return null;
  }
  const personTaskDataArray = JSON.parse(personTaskData);

// 日付型の復元処理（例：taskDate プロパティが日付の場合）
  const revivedData = personTaskDataArray.map((task: any) => ({
    ...task,
    start: new Date(task.start), // ← ここで Date 型に変換
    completed: new Date(task.completed)
  }));

  return revivedData;
};

// 特定のタスクを更新する関数
export const updateSessionStoragePersonTaskData = (person: Person, taskToUpdate: PersonTaskData) => {
  const key = sessionStorageKey + person.id;
  const existingData = sessionStorage.getItem(key);
  
  if (existingData) {
    const taskArray = JSON.parse(existingData);
    
    // タスクとプロジェクトで該当するタスクを見つけて更新
    const taskIndex = taskArray.findIndex((task: PersonTaskData) => 
      task.task === taskToUpdate.task && task.project === taskToUpdate.project
    );
    
    if (taskIndex !== -1) {
      taskArray[taskIndex] = { ...taskArray[taskIndex], ...taskToUpdate };
      sessionStorage.setItem(key, JSON.stringify(taskArray));
      return true;
    }
  }
  return false;
};
