import { Component, Input, OnInit, OnChanges, SimpleChanges } from '@angular/core';
import { CommonModule } from '@angular/common';
import { WjChartModule } from '@mescius/wijmo.angular2.chart';
import { WjGaugeModule } from '@mescius/wijmo.angular2.gauge';
import { WjCoreModule } from '@mescius/wijmo.angular2.core';
import { DataService, PersonTaskData } from '../data.service';
import { Person } from '../persons-list/persons-list.component';

import { HitTestInfo } from '@mescius/wijmo.chart';

@Component({
  selector: 'app-task-completion-info',
  templateUrl: './task-completion-info.component.html',
  styleUrls: ['./task-completion-info.component.css'],
  standalone: true,
  imports: [CommonModule, WjChartModule, WjGaugeModule, WjCoreModule]
})
export class TaskCompletionInfoComponent implements OnInit, OnChanges {
  @Input('selectedPerson') selectedPerson: Person | null = null;
  @Input('personTaskData') personTaskData: PersonTaskData[] = null;
  taskCompletionData: any[];
  platformTooltip = '選択された人物のタスク完了状況です。';
  piePalette = ['#4caf50', '#ff9800', '#f44336']; // 完了:緑、進行中:オレンジ、未着手:赤

  constructor(private dataService: DataService) {
    // デフォルトデータ（誰も選択されていない時）
    this.taskCompletionData = [
      { status: '完了', count: 12, percentage: 70 },
      { status: '進行中', count: 5, percentage: 20 },
      { status: '未着手', count: 0, percentage: 10 }
    ];

    //
    this.updateTaskCompletionData();
  }

  ngOnInit(): void {}

  ngOnChanges(changes: SimpleChanges): void {
    if (/*changes['selectedPerson'] &&*/ this.selectedPerson) {
      this.updateTaskCompletionData();
      this.platformTooltip = `${this.selectedPerson.name}のタスク完了状況です。`;
    }
  }

  private updateTaskCompletionData(): void {
    if (!this.selectedPerson) return;

    // ステータス別の集計
    const completedTasks = this.personTaskData.filter(task => task.status === 'completed').length;
    const inProgressTasks = this.personTaskData.filter(task => task.status === 'in-progress').length;
    const notStartedTasks = this.personTaskData.filter(task => task.status === 'not-started').length;
    const totalTasks = this.personTaskData.length; // + ;

    // 円グラフ用のデータを生成
    this.taskCompletionData = [];
    
    if (completedTasks > 0) {
      this.taskCompletionData.push({
        status: '完了',
        count: completedTasks,
        percentage: Math.round((completedTasks / totalTasks) * 100)
      });
    }
    
    if (inProgressTasks > 0) {
      this.taskCompletionData.push({
        status: '進行中',
        count: inProgressTasks,
        percentage: Math.round((inProgressTasks / totalTasks) * 100)
      });
    }

    if (notStartedTasks > 0) {
      this.taskCompletionData.push({
        status: '未着手',
        count: notStartedTasks,
        percentage: Math.round((notStartedTasks / totalTasks) * 100)
      });
    }
  }

  getStatusColor(status: string): string {
    switch (status) {
      case '完了': return '#4caf50';
      case '進行中': return '#ff9800';
      case '未着手': return '#f44336';
      default: return '#9e9e9e';
    }
  }

    tooltipContent(hti: HitTestInfo) {
          return `<b>${hti.value} 件</b>`;
    } 
}
