﻿import { Component, EventEmitter, Inject, Input, OnChanges, Output } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';
import { WjInputModule } from '@mescius/wijmo.angular2.input';
import { WjCoreModule } from '@mescius/wijmo.angular2.core';
import * as wijmo from '@mescius/wijmo';
import { Calendar, InputDate, FormatItemEventArgs } from '@mescius/wijmo.input';
import { Person } from 'src/app/persons-list/persons-list.component';
import { UserInfo } from '../user-info.component';
import { DataService, PersonTaskData } from 'src/app/data.service';

@Component({
  selector: 'app-user-edit',
  templateUrl: './user-edit.component.html',
  styleUrls: ['./user-edit.component.css'],
  standalone: true,
  imports: [CommonModule, FormsModule, WjInputModule, WjCoreModule]
})

export class UserEditComponent implements OnChanges {
  @Input() userInfo: UserInfo | null = null;
  @Input() person: Person ;
  @Output() close = new EventEmitter<UserInfo | null>();
  status: any[] = [{display: '進行中', value: 'in-progress'}, {display: '完了', value: 'completed'}]; // ステータス
  tasks: any;
  projects: any;
  formData: UserInfo;
  personTaskData: PersonTaskData[];
  minEndDate: Date | null = null;

  ngOnChanges(): void {
    const deptData = this.dataService.departmentTasks[this.person.department];
    this.personTaskData = this.dataService.getPersonTaskData(this.person.name, this.person.department);
    this.tasks = deptData.tasks; // tasks
    this.projects = deptData.projects; // todo
    // const com = this.getAvailablePairs(this.tasks, this.projects, this.personTaskData);
    // console.log('tasks ' + JSON.stringify(this.tasks));
    // console.log('projects ' + JSON.stringify(this.projects));
    // console.log('com ' + JSON.stringify(com));


    this.formData = {
      task: deptData.tasks[0],
      project: deptData.projects[0],
      person: this.person,
      start: null,
      completed: null,
      status: 'not-started',
    };
  }

  onSave() {
    // バリデーションチェック
    if (!this.checkValidate(this.formData)) { return; }

    this.close.emit(this.formData);
  }

  onCancel() {
    this.close.emit(null);
  }

  clearErrorText() {
    const startErrorText = document.getElementById('startErrorText');
    startErrorText.textContent = '';
    const completedErrorText = document.getElementById('completedErrorText');
    completedErrorText.textContent = '';
  }

  checkValidate(updatedUser: UserInfo) {
    this.clearErrorText();

    let isvaildError = true;
    if (updatedUser.start === null) {
        const startErrorText = document.getElementById('startErrorText');
        startErrorText.textContent = '開始日を入力してください。';
        isvaildError = false;
    }
    if (updatedUser.completed === null) {
        const completedErrorText = document.getElementById('completedErrorText');
        completedErrorText.textContent = '終了日を入力してください。';
        isvaildError = false;
    }
    return isvaildError;
  }

  constructor(@Inject(DataService) private dataService: DataService) {
      // change InpuDate icon to a calendar instead of a down arrow (applies to all InputDate controls)
      InputDate.controlTemplate = '<div style="position:relative" class="wj-template">' +
          '<div class="wj-input">' +
          '<div class="wj-input-group wj-input-btn-visible">' +
          '<input wj-part="input" type="text" class="wj-form-control" />' +
          '<span wj-part="btn" class="wj-input-group-btn" tabindex="-1">' +
          '<button class="wj-btn wj-btn-default" type="button" tabindex="-1">' +
          '<span class="wj-glyph-calendar"></span>' +
          '</button>' +
          '</span>' +
          '</div>' +
          '</div>' +
          '<div wj-part="dropdown" class="wj-content wj-dropdown-panel" ' +
          'style="display:none;position:absolute;z-index:100">' +
          '</div>' +
          '</div>';
      //
      // change the format used to show current month/year (affects all InputDate and Calendar controls)
      wijmo.culture.Globalize.calendar.patterns.y = 'yyyy/M';
  }

  customizeCalendar(calendar: Calendar) {
    calendar.formatItem.addHandler((sender: Calendar, e: FormatItemEventArgs) => {
        const weekday = e.data.getDay();
        const holiday = this.dataService.getHoliday(e.data);

        wijmo.toggleClass(e.item, 'date-sunday', weekday === 0);
        wijmo.toggleClass(e.item, 'date-saturday', weekday === 6);
        wijmo.toggleClass(e.item, 'date-holiday', holiday != null);
        e.item.title = holiday || '';
    });
  }

  onStartDateChanged(startDate: Date): void {
    if (startDate && startDate instanceof Date) {
      // 開始日の翌日を最小終了日として設定
      const nextDay = new Date(startDate);
      nextDay.setDate(nextDay.getDate() + 1);
      this.minEndDate = nextDay;
    } else {
      this.minEndDate = null;
    }
  }
}
